/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import lotus.domino.Agent;
import lotus.domino.AgentBase;
import lotus.domino.AgentContext;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.Session;

/**
 * 
 * Beispiel Code fr einen Java Agenten zum Start eines 
 * server basierten Agenten.
 * Code zur Verwendung in einem im Domino Designer angelegten Java Agenten.
 * (Im Java Agenten muss die package Deklaration entfernt werden.)
 * 
 * @author Thomas Ekert
 */
public class StartAgent extends AgentBase {

	public void NotesMain() {
		
		Document parameter = null;
		try {
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();
			Database db = agentContext.getCurrentDatabase();
			parameter = agentContext.getDocumentContext();
			Agent ag = db.getAgent("AG_serverBasedAgent");
			System.out.println(
				"Starte AG_serverBasedAgent auf Server <<"
					+ db.getServer()
					+ ">>");
			String noteID = parameter.getNoteID();
			int result = ag.runOnServer(noteID);
			System.out.println(
				"AG_serverBasedAgent wurde "
					+ (result == 0 ? "erfolgreich" : "fehlerhaft")
					+ " ausgefhrt.");
			parameter.recycle();
			parameter = db.getDocumentByID(noteID);
			System.out.println(
				"Ausfhrungszeiten: "
					+ parameter.getItemValue("F_ranOnServerTime").toString());
			System.out.println(
				"Servernamen: "
					+ parameter.getItemValue("F_ranOnServerName").toString());
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			if (parameter != null) {
				try {
					parameter.recycle();
				} catch (NotesException e1) {
					e1.printStackTrace();
				}
			}
		}
	}
}
